from collections import namedtuple

# načtení názvů států ze souboru s plochami
plochy = {} # slovník
with open('staty_plochy.log') as soubor:
    for řádka in soubor:
        stát, plocha = řádka.rstrip('\n').split(': ')
        plochy[stát] = plocha   # pod klíčem stát bude jeho plocha

# načtení názvů států ze souboru s počtem obyvatel
lidi = {}   # slovník
with open('staty_lidi.log') as soubor:
    for řádka in soubor:
        stát, počet_obyvatel = řádka.rstrip('\n').split(': ')
        lidi[stát] = počet_obyvatel # pod klíčem stát bude jeho počet obyvatel

# slovník hustoty zalidnění klíčovaný názvem státu
státy = {}

# pojmenovaná n-tice pro uložení informací o konkrétním státu
Stát = namedtuple('StátInfo', 'plocha lidí hustota')

# počtů obyvatel je méně a všechny jejich státy jsou i v plochách, ale opačně to není pravda -- ploch je o 24 více než lidí
for stát in plochy:
    # pro 24 států neexistuje záznam o počtu obyvatel, ale metoda get() se o to postará a vrátí pro ně 0
    počet_obyvatel = lidi.get(stát, 0)
    # záznam pro plochy existuje pro všechny státy
    plocha = plochy[stát]
    státy[stát] = Stát(
        plocha,
        počet_obyvatel,
        int(počet_obyvatel) / float(plocha)
    )
    # PS: int(0) = 0 takže nevadí, že get() vrací rovnou číslo

# výpis států seřazený podle hustoty zalidnění
for stát in sorted(státy, key=lambda x: státy[x].hustota):
    data = státy[stát]
    print(f'{stát} -> {data.hustota}')
